/**
 * WPvulnerability admin scripts.
 *
 * @package WPVulnerability
 */

if ( typeof jQuery !== 'undefined' ) {
		jQuery( document ).on(
			'wp-plugin-update-success',
			function ( event, args ) {
				jQuery( 'tr[data-plugin="' + args.plugin + '"]' ).nextAll( '.wpvulnerability' ).first().remove();
			}
		);
}

document.addEventListener(
	'DOMContentLoaded',
	function () {
		var periodRadios = document.querySelectorAll( 'input[name="wpvulnerability-config[period]"]' );
		var dayWrap      = document.getElementById( 'wpvulnerability_day_wrap' );
		var timeWrap     = document.getElementById( 'wpvulnerability_time_wrap' );

		if ( ! periodRadios.length || ! dayWrap || ! timeWrap ) {
			return;
		}

		function toggleFields() {
			var checked = document.querySelector( 'input[name="wpvulnerability-config[period]"]:checked' );
			var value   = checked ? checked.value : null;

			if ( value === 'daily' ) {
					dayWrap.style.display  = 'none';
					timeWrap.style.display = '';
			} else if ( value === 'weekly' ) {
				dayWrap.style.display  = '';
				timeWrap.style.display = '';
			} else {
				dayWrap.style.display  = 'none';
				timeWrap.style.display = 'none';
			}
		}

		toggleFields();
		periodRadios.forEach(
			function ( radio ) {
				radio.addEventListener( 'change', toggleFields );
			}
		);

		var notifyOptions = [
				{
					checkboxSelector: 'input[name="wpvulnerability-config[notify][email]"]',
					fieldId: 'wpvulnerability_emails',
		},
				{
					checkboxSelector: 'input[name="wpvulnerability-config[notify][slack]"]',
					fieldId: 'wpvulnerability_slack_webhook',
		},
				{
					checkboxSelector: 'input[name="wpvulnerability-config[notify][teams]"]',
					fieldId: 'wpvulnerability_teams_webhook',
		},
		];

		function toggleRow( checkbox, row ) {
			if ( ! checkbox || ! row ) {
				return;
			}

			row.style.display = checkbox.checked ? '' : 'none';
		}

			notifyOptions.forEach(
				function ( option ) {
					var checkbox = document.querySelector( option.checkboxSelector );
					var row      = document.getElementById( option.fieldId );
					row          = row ? row.closest( 'tr' ) : null;

					toggleRow( checkbox, row );

					if ( checkbox ) {
						checkbox.addEventListener(
							'change',
							function () {
								toggleRow( checkbox, row );
							}
						);
					}
				}
			);

	}
);
