<?php
/**
 * Plugin Name: WPVulnerability
 * Plugin URI: https://www.wpvulnerability.com/
 * Description: Receive information about possible vulnerabilities in your WordPress from WordPress Vulnerability Database API.
 * Requires at least: 4.7
 * Requires PHP: 5.6
 * Version: 4.2.1.1
 * Author: Javier Casares
 * Author URI: https://www.javiercasares.com/
 * License: GPL-2.0-or-later
 * License URI: https://spdx.org/licenses/GPL-2.0-or-later.html
 * Text Domain: wpvulnerability
 * Domain Path: /languages
 *
 * @package WPVulnerability
 *
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

/**
 * Set some constants that I can change in future versions.
 */
define( 'WPVULNERABILITY_PLUGIN_VERSION', '4.2.1.1' );
define( 'WPVULNERABILITY_API_HOST', 'https://www.wpvulnerability.net/' );

/**
 * Set some useful constants.
 */
define( 'WPVULNERABILITY_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_FILE', __FILE__ );
define( 'WPVULNERABILITY_PLUGIN_BASE', plugin_basename( __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

// Handle front-end email opt-out requests early.
if ( isset( $_GET['wpvulnerability_disable_email'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	// Load pluggable functions so wp_verify_nonce() is available.
	if ( ! function_exists( 'wp_verify_nonce' ) ) {
		require_once ABSPATH . WPINC . '/pluggable.php';
	}

	if ( ! defined( 'SECURE_AUTH_COOKIE' ) ) {
		if ( ! function_exists( 'wp_cookie_constants' ) ) {
			require_once ABSPATH . WPINC . '/default-constants.php';
		}

		if ( function_exists( 'wp_cookie_constants' ) ) {
			wp_cookie_constants();
		}
	}

	if ( ! function_exists( 'wpvulnerability_normalize_notify_settings' ) ) {
		require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-general.php';
	}

	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-notifications.php';

	if ( function_exists( 'wpvulnerability_disable_notifications_via_url' ) ) {
		wpvulnerability_disable_notifications_via_url();
	}
}

/**
 * Initialize the plugin.
 *
 * @since 2.0.0
 *
 * @return void
 */
function wpvulnerability_plugin_init() {
	wpvulnerability_initialize_plugin_data();

	/*
	 * Global functions, where the magic happens.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-general.php';

	/*
	 * The admin panel for the configuration.
	 *
	 * @since 2.0.0
	 */
	if ( is_multisite() && is_network_admin() ) {
		require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-adminms.php';
	} elseif ( ! is_multisite() && is_admin() ) {
		require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-admin.php';
	}

	/*
	 * The functions to work with the data.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-core.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-plugins.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-themes.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-software.php';

	/*
	 * All the plugin really does.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-process.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-notifications.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-sitehealth.php';
		require_once WPVULNERABILITY_PLUGIN_PATH . '/class-wpvulnerability-cli.php';
		require_once WPVULNERABILITY_PLUGIN_PATH . '/class-wpvulnerability-config-cli.php';

		// Update non-cached data.
		wpvulnerability_expired_database_data();
}

/*
 * Backward compatibility for wp_doing_cron().
 *
 * wp_doing_cron() was introduced in WordPress 4.8. This plugin supports
 * versions as old as WordPress 4.7, so define the function when it does not
 * exist in core.
 *
 * @since 4.1.1
 */
if ( ! function_exists( 'wp_doing_cron' ) ) {
		/**
		 * Determines whether the current request is a WordPress cron request.
		 *
		 * Mirrors the core wp_doing_cron() function available since 4.8.0.
		 *
		 * @since 4.1.1
		 *
		 * @return bool Whether the current request is a WordPress cron request.
		 */
	function wp_doing_cron() {
			return apply_filters( 'wp_doing_cron', defined( 'DOING_CRON' ) && DOING_CRON );
	}
}

/*
 * Only load if it's admin / super admin.
 */
if (
				( ! is_multisite() && is_admin() ) ||
		( is_multisite() && ( is_network_admin() || is_main_site() ) ) ||
		( defined( 'WP_CLI' ) && WP_CLI ) ||
		wp_doing_cron()
	) {

	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-run.php';
	register_activation_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_activation' );
	register_deactivation_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_deactivation' );
	register_uninstall_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_uninstall' );
	add_action( 'init', 'wpvulnerability_plugin_init' );
}

/*
 * The plugin really needs this.
 *
 * @since 3.1.0
 */
require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-schedule.php';
require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-api.php';
