<?php
/**
 * Scheduling functions
 *
 * @package WPVulnerability
 *
 * @version 3.1.0
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

/**
 * Schedule Automatic Vulnerability Database Update.
 * If the 'wpvulnerability_update_database' event is not already scheduled, schedule it to run twice daily.
 *
 * @since 2.0.0
 *
 * @return void
 */
if ( ! wp_next_scheduled( 'wpvulnerability_update_database' ) ) {
	// Schedule the event only for the main site in a multisite network or for a single site.
	if ( ! is_multisite() || ( is_multisite() && is_main_site() ) ) {
		wp_schedule_event( time(), 'twicedaily', 'wpvulnerability_update_database' );
	}
}

// Hook the event to the function that updates the database.
add_action( 'wpvulnerability_update_database', 'wpvulnerability_update_database_data' );

/**
 * Schedule vulnerability notification and execute notification function.
 *
 * @since 2.0.0
 *
 * @return void
 */
$wpvulnerability_s = array();
if ( is_multisite() ) {
	$wpvulnerability_s = get_site_option( 'wpvulnerability-config' );
} else {
	$wpvulnerability_s = get_option( 'wpvulnerability-config' );
}

// Check if notification period is set.
if ( isset( $wpvulnerability_s['period'] ) ) {

	// Check if notification is not already scheduled.
	if ( ! wp_next_scheduled( 'wpvulnerability_notification' ) ) {

		// Schedule notification.
		if ( ! is_multisite() || ( is_multisite() && is_main_site() ) ) {
			wp_schedule_event( time(), $wpvulnerability_s['period'], 'wpvulnerability_notification' );
		}
	}

	// Add action to execute notification function.
	add_action( 'wpvulnerability_notification', 'wpvulnerability_execute_notification' );
}

// Clean up.
unset( $wpvulnerability_s );
