<?php
/**
 * Plugin Name: WPVulnerability
 * Plugin URI: https://www.wpvulnerability.com/
 * Description: Receive information about possible vulnerabilities in your WordPress from WordPress Vulnerability Database API.
 * Requires at least: 4.1
 * Requires PHP: 5.6
 * Version: 3.4.0
 * Author: Javier Casares
 * Author URI: https://www.javiercasares.com/
 * License: GPL-2.0-or-later
 * License URI: https://spdx.org/licenses/GPL-2.0-or-later.html
 * Text Domain: wpvulnerability
 * Domain Path: /languages
 *
 * @package WPVulnerability
 *
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

/**
 * Set some constants that I can change in future verions
 */
define( 'WPVULNERABILITY_PLUGIN_VERSION', '3.4.0' );
define( 'WPVULNERABILITY_API_HOST', 'https://www.wpvulnerability.net/' );
define( 'WPVULNERABILITY_CACHE_HOURS', 12 );

/**
 * Set some useful constants
 */
define( 'WPVULNERABILITY_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_FILE', __FILE__ );
define( 'WPVULNERABILITY_PLUGIN_BASE', plugin_basename( __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

/**
 * Initialize the plugin.
 *
 * @since 2.0.0
 *
 * @return void
 */
function wpvulnerability_plugin_init() {
	/*
	 * Load the plugin's localization files.
	 *
	 * @since 2.0.0
	 */
	load_plugin_textdomain( 'wpvulnerability', false, dirname( WPVULNERABILITY_PLUGIN_BASE ) . '/languages' );
	wpvulnerability_activation();

	/*
	 * Global functions, where the magic happens.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-general.php';

	/*
	 * The admin panel for the configuration.
	 *
	 * @since 2.0.0
	 */
	if ( is_multisite() && is_network_admin() ) {
		require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-adminms.php';
	} elseif ( ! is_multisite() && is_admin() ) {
		require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-admin.php';
	}

	/*
	 * The functions to work with the data.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-core.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-plugins.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-themes.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-php.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-apache.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-nginx.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-mariadb.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-mysql.php';

	/*
	 * All the plugin really does.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-process.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-notifications.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-sitehealth.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-cli.php';

	// Update non-cached data.
	wpvulnerability_expired_database_data();
}

/*
 * Only load if it's admin / super admin
 */
if ( ( ! is_multisite() && is_admin() ) || ( is_multisite() && ( is_network_admin() || is_main_site() ) ) || ( defined( 'WP_CLI' ) && WP_CLI ) || wp_doing_cron() ) {

	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-run.php';
	register_activation_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_activation' );
	register_deactivation_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_deactivation' );
	register_uninstall_hook( WPVULNERABILITY_PLUGIN_FILE, 'wpvulnerability_uninstall' );
	add_action( 'plugins_loaded', 'wpvulnerability_plugin_init' );

}

/*
 * The plugin really need this.
 *
 * @since 3.1.0
 */
require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-schedule.php';
require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-api.php';
