<?php
/**
 * What should be done when uninstalling the plugin.
 * Do not leave anything behind and people will be happy having a clean WordPress.
 *
 * @package WPVulnerability
 * @version 2.0.0
 */
if ( defined( 'ABSPATH' ) && defined( 'WP_UNINSTALL_PLUGIN' ) ) {

	/**
	 * Deprecated options.
	 */
	delete_option( 'wpvulnerability_settings' );
	delete_option( 'wpvulnerability-data' );

	/**
	 * All the data.
	 */
	delete_option( 'wpvulnerability-themes' );
	delete_option( 'wpvulnerability-themes-cache' );
	delete_option( 'wpvulnerability-themes-vulnerable' );
	delete_option( 'wpvulnerability-plugins' );
	delete_option( 'wpvulnerability-plugins-cache' );
	delete_option( 'wpvulnerability-plugins-vulnerable' );
	delete_option( 'wpvulnerability-core' );
	delete_option( 'wpvulnerability-core-cache' );
	delete_option( 'wpvulnerability-core-vulnerable' );

	/**
	 * Config data, not deleted when deactivated.
	 */
	delete_option( 'wpvulnerability-config' );

}
