<?php
/**
 * Plugin Name: WPVulnerability
 * Plugin URI: https://vulnerability.wpsysadmin.com/
 * Description: Check WordPress core, plugins, and theme vulnerabilities with information from the WordPress Vulnerability Database API.
 * Requires at least: 4.1
 * Requires PHP: 5.6
 * Version: 2.0.0
 * Author: Javier Casares
 * Author URI: https://www.javiercasares.com/
 * Text Domain: wpvulnerability
 * Domain Path: /languages
 * License: EUPL v1.2
 * License URI: https://www.eupl.eu/1.2/en/
 *
 * @package WPVulnerability
 *
 * @version 2.0.0
 *
 */
defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

/**
 * Set some constants that I can change in future verions
 */
define( 'WPVULNERABILITY_PLUGIN_VERSION', '2.0.0' );
define( 'WPVULNERABILITY_API_HOST', 'https://www.wpvulnerability.net/' );
define( 'WPVULNERABILITY_CACHE_HOURS', 12 );

/**
 * Set some useful constants
 */
define( 'WPVULNERABILITY_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_FILE', __FILE__ );
define( 'WPVULNERABILITY_PLUGIN_BASE', plugin_basename( __FILE__ ) );
define( 'WPVULNERABILITY_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

/**
 * Initialize the plugin.
 *
 * @since 2.0.0
 *
 * @return void
 */
function wpvulnerability_plugin_init() {
	/*
	 * Load the plugin's localization files.
	 *
	 * @since 2.0.0
	 */
	load_plugin_textdomain( 'wpvulnerability', false, dirname( WPVULNERABILITY_PLUGIN_BASE ) . '/languages' );

	/*
	 * Global functions, where the magic happens.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-run.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-general.php';

	/*
	 * The admin panel for the configuration.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-admin.php';

	/*
	 * The functions to work with the data.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-plugins.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-themes.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-core.php';
	/*
	 * All the plugin really does.
	 *
	 * @since 2.0.0
	 */
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-process.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-notifications.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-sitehealth.php';
	require_once WPVULNERABILITY_PLUGIN_PATH . '/wpvulnerability-cli.php';

}
add_action( 'plugins_loaded', 'wpvulnerability_plugin_init' );
