<?php
/**
 * Plugin Name: WPVulnerability
 * Plugin URI:  https://vulnerability.wpsysadmin.com/
 * Description: Check the security of a WordPress site with information from the WordPress Vulnerability Database API. Scans Core, plugins, and theme vulnerabilities.
 * Requires at least: 5.2
 * Requires PHP: 7.2
 * Version:     1.3.0
 * Author:      Javier Casares
 * Author URI:  https://www.javiercasares.com/
 * Text Domain: wpvulnerability
 * Domain Path: /languages
 * License:     EUPL v1.2
 * License URI: https://www.eupl.eu/1.2/en/
 *
 * @package     WordPress
 * @author      Closetechnology
 * @copyright   2022 Closetechnology
 * @license     GPL-2.0+
 *
 * @wordpress-plugin
 *
 * Prefix:      wpvul
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

define( 'WPVUL_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
define( 'WPVUL_PLUGIN_VERSION', '1.3.0' );
define( 'WPVUL_PLUGIN_FILE', __FILE__ );
define( 'WPVUL_PLUGIN_BASE', plugin_basename( __FILE__ ) );
define( 'WPVUL_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

add_action( 'plugins_loaded', 'wpvul_plugin_init' );
/**
 * Load localization files
 *
 * @return void
 */
function wpvul_plugin_init() {
	load_plugin_textdomain( 'wpvulnerability', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}

require_once WPVUL_PLUGIN_PATH . '/includes/helpers-api.php';
require_once WPVUL_PLUGIN_PATH . '/includes/class-plugins-wpvulnerability.php';
require_once WPVUL_PLUGIN_PATH . '/includes/class-health-wpvulnerability.php';
require_once WPVUL_PLUGIN_PATH . '/includes/class-cli-wpvulnerability.php';
require_once WPVUL_PLUGIN_PATH . '/includes/class-wpvul-admin-settings.php';
require_once WPVUL_PLUGIN_PATH . '/includes/class-wpvul-notification.php';

// Initialize our plugin.
$plugins_wpvulnnerability = new Plugins_WPVulnerability();
new CLI_WPVulnerability( $plugins_wpvulnnerability );
