<?php
/**
 * Primary class file for CLI commands.
 *
 * @package Health Check
 */

// Make sure the file is not directly accessible.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'We\'re sorry, but you cannot directly access this file.' );
}

/**
 * Class CLI commands.
 */
class CLI_WPVulnerability {
	/**
	 * CLI constructor.
	 *
	 * @param object $plugins_wpvulnerability.
	 *
	 */
	public function __construct( $plugins_wpvulnerability ) {
		$this->plugins = $plugins_wpvulnerability->get_installed_plugins();
		if ( class_exists( 'WP_CLI' ) ) {
			WP_CLI::add_command(
				'wpvulnerability',
				array( $this, 'cli_command' ),
				array(
					'shortdesc' => 'Show the list of vulnerabilities detected in your site.',
					'synopsis'  => array(
						array(
							'type'        => 'positional',
							'name'        => 'subcommand',
							'description' => 'subcommand [core|plugins|themes].',
							'optional'    => false,
							'repeating'   => false,
						),
					),
					'when'      => 'after_wp_load',
					'longdesc'  => '## EXAMPLES' . "\n\n" . 'wp wpvulnerability plugins',
				)
			);
		}
	}

	/**
	 * Switches the command
	 *
	 * @param array $args Type of command.
	 * @return void
	 */
	public function cli_command( $args ) {
		switch ( $args[0] ) {
			case 'core':
				$this->core_subcommand();
				break;
			case 'plugins':
				$this->plugins_subcommand();
				break;
			case 'themes':
				$this->themes_subcommand();
				break;
			default:
				WP_CLI::error( "'$args[0]' is not a registered subcommand of 'wpvulnerability'.\nAvailable subcommands: core, plugins, themes" );
				break;
		}
	}

	/**
	 * Themes section.
	 */
	public function core_subcommand() {
		// TODO.
		WP_CLI::error( 'Command not implemented yet' );
	}

	/**
	 * Plugin section
	 */
	public function plugins_subcommand() {
		foreach ( $this->plugins as $plugin ) {
			if ( 'true' === $plugin['vulnerable'] ) {
				$name = $plugin['Name'];
				WP_CLI::line( WP_CLI::colorize( "%r$name:%n " ) );
				$vulnerabilities = array();
				foreach ( $plugin['vulnerabilities'] as $vulnerability ) {
					$sources = '';
					foreach ( $vulnerability['source'] as $source ) {
						$sources .= $source['link'] . "\n";
					}
					array_push(
						$vulnerabilities,
						array(
							'name'     => $vulnerability['name'],
							'versions' => $vulnerability['versions'],
							'source'   => $sources,
						)
					);
				}
				WP_CLI\Utils\format_items(
					'table',
					$vulnerabilities,
					array( 'name', 'versions', 'source' )
				);

			}
		}
	}

	/**
	 * Themes section
	 */
	public function themes_subcommand() {
		// TODO.
		WP_CLI::error( 'Command not implemented yet' );
	}
}
